﻿Imports System.IO
Imports System.Windows.Media.Imaging
Imports System.Device.Location
Imports SilverlightLocationMapper.MsrMapsService

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private geoWatcher As New GeoCoordinateWatcher()
    Private proxy As New TerraServiceSoapClient()


    Public Sub New()
        InitializeComponent()
        AddHandler Loaded, AddressOf OnMainPageLoaded
    End Sub


    Private Sub OnMainPageLoaded(ByVal sender As Object, ByVal args As RoutedEventArgs)
        ' Set event handlers for TerraServiceSoapClient proxy
        AddHandler proxy.GetAreaFromPtCompleted, AddressOf OnProxyGetAreaFromPtCompleted
        AddHandler proxy.GetTileCompleted, AddressOf OnProxyGetTileCompleted

        ' Start GeoCoordinateWatcher going
        statusText.Text = "Obtaining geographic location..."
        AddHandler geoWatcher.PositionChanged, AddressOf OnGeoWatcherPositionChanged
        geoWatcher.Start()
    End Sub


    Private Sub OnGeoWatcherPositionChanged(ByVal sender As Object,
                                            ByVal args As GeoPositionChangedEventArgs(Of GeoCoordinate))
        ' Turn off GeoWatcher
        RemoveHandler geoWatcher.PositionChanged, AddressOf OnGeoWatcherPositionChanged
        geoWatcher.Stop()

        ' Set coordinates to title text
        Dim coord = args.Position.Location
        ApplicationTitle.Text &= ": " & String.Format("{0:F2}°{1} {2:F2}°{3}",
                                                      Math.Abs(coord.Latitude),
                                                      If(coord.Latitude > 0, "N"c, "S"c),
                                                      Math.Abs(coord.Longitude),
                                                      If(coord.Longitude > 0, "E"c, "W"c))
        ' Query proxy for AreaBoundingBox                 
        Dim center As New LonLatPt()
        center.Lon = args.Position.Location.Longitude
        center.Lat = args.Position.Location.Latitude

        statusText.Text = "Accessing Microsoft Research Maps Service..."
        proxy.GetAreaFromPtAsync(center, 1,
                                 Scale.Scale16m,
                                 CInt(ContentPanel.ActualWidth),
                                 CInt(ContentPanel.ActualHeight))
    End Sub


    Private Sub OnProxyGetAreaFromPtCompleted(ByVal sender As Object,
                                              ByVal args As GetAreaFromPtCompletedEventArgs)
        If args.Error IsNot Nothing Then
            statusText.Text = args.Error.Message
            Return
        End If

        statusText.Text = "Getting map tiles..."

        Dim box = args.Result
        Dim xBeg = box.NorthWest.TileMeta.Id.X
        Dim yBeg = box.NorthWest.TileMeta.Id.Y
        Dim xEnd = box.NorthEast.TileMeta.Id.X
        Dim yEnd = box.SouthWest.TileMeta.Id.Y

        ' Loop through the tiles
        For x = xBeg To xEnd
            For y = yBeg To yEnd Step -1
                ' Create Image object to display tile
                Dim img As New Image()
                img.Stretch = Stretch.None
                img.HorizontalAlignment = HorizontalAlignment.Left
                img.VerticalAlignment = VerticalAlignment.Top
                img.Margin = New Thickness((x - xBeg) * 200 - box.NorthWest.Offset.XOffset,
                                           (yBeg - y) * 200 - box.NorthWest.Offset.YOffset,
                                           0, 0)

                ' Insert after TextBlock but before Image with logo
                ContentPanel.Children.Insert(1, img)

                ' Define the tile ID
                Dim tileId = box.NorthWest.TileMeta.Id
                tileId.X = x
                tileId.Y = y

                ' Call proxy to get the tile (Notice that Image is user object)
                proxy.GetTileAsync(tileId, img)
            Next y
        Next x
    End Sub


    Private Sub OnProxyGetTileCompleted(ByVal sender As Object,
                                        ByVal args As GetTileCompletedEventArgs)
        If args.Error IsNot Nothing Then
            Return
        End If

        Dim img = TryCast(args.UserState, Image)
        Dim bmp As New BitmapImage()
        bmp.SetSource(New MemoryStream(args.Result))
        img.Source = bmp
    End Sub
End Class